<?php

function enqueue_fe_react_app() {
    // Path to the build directory
    $build_dir = plugin_dir_path(__FILE__) . '../../../frontend/';
    
    // Load the manifest file
    $manifest_file = $build_dir . 'asset-manifest.json';
    // print_r($manifest_file); die;
    if (file_exists($manifest_file)) {
        $manifest = json_decode(file_get_contents($manifest_file), true);

        // Enqueue the main JS file
        if (!empty($manifest['files']['main.js'])) {
            wp_enqueue_script('caravan-react-fe-app', plugins_url('../../../frontend/' . $manifest['files']['main.js'], __FILE__), array(), null, true);
        }

        // Enqueue the main CSS file
        if (!empty($manifest['files']['main.css'])) {
            wp_enqueue_style('caravan-react-fe-app', plugins_url('../../../frontend/' . $manifest['files']['main.css'], __FILE__));
        }
        
        // Enqueue any additional chunk files (like 453.28a215d1.chunk.js)
        if (!empty($manifest['files']['runtime-main.js'])) {
            wp_enqueue_script('caravan-react-fe-runtime', plugins_url('../../../frontend/' . $manifest['files']['runtime-main.js'], __FILE__), array(), null, true);
        }
        foreach ($manifest['files'] as $file => $path) {
            if (strpos($file, 'chunk.js') !== false) {
                wp_enqueue_script('caravan-react-fe-chunk-' . $file, plugins_url('../../../frontend/' . $path, __FILE__), array(), null, true);
            }
        }
    }
}

// Function that outputs the shortcode content
function bitsia_caravan_builder_shortcode($atts) {
    $email = get_option( 'bcb_email', '' );
    $key = get_option( 'bcb_key', '' );
    $enckey = "g7Yf2k9LqW3Xv8Zt5R1pS6NmD0oH4jEa"; // 32 bytes for AES-256
    $iv = openssl_random_pseudo_bytes(16); // 16 bytes IV for AES

    // Encrypt data
    $cipher = "AES-256-CBC";
    $encrypted = openssl_encrypt($key, $cipher, $enckey, OPENSSL_RAW_DATA, $iv);

    // Encode IV and encrypted data for transmission/storage
    $encryptedData = base64_encode($iv . $encrypted);

    // Set default attributes
    $atts = shortcode_atts(
        array(
            'id' => 'default',
        ),
        $atts,
        'caravan-builder'
    );

    // Enqueue the React app assets
    enqueue_fe_react_app();

    // Return the output
    return '
        <script>
            var  bcbData = {
                email: "' . esc_js( $email ) . '",
                key: "' . esc_js( $encryptedData ) . '"
            };
        </script>
        <div class="bitsia-caravan-builder-plugin">
            <div id="root" class="wrap"></div>
        </div>
    ';
}

// Register the shortcode
add_shortcode('caravan-builder', 'bitsia_caravan_builder_shortcode');
